
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    P = model.addVar(lb=0, name="Peggy_hours")
    L = model.addVar(lb=0, name="Laura_hours")
    R = model.addVar(lb=0, name="Ringo_hours")

    # Objective function
    model.setObjective(9.55 * P + 4.63 * L + 1.21 * R, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * L + 6 * R >= 26, name="org_score_LR")
    model.addConstr(2 * P + 8 * L >= 18, name="org_score_PL")
    model.addConstr(2 * P + 8 * L + 6 * R >= 18, name="org_score_PLR")
    model.addConstr(8 * L + 7 * R >= 10, name="work_quality_LR")
    model.addConstr(6 * P + 8 * L + 7 * R >= 12, name="work_quality_PLR")
    model.addConstr(6 * P + 10 * L >= 22, name="dollar_cost_PL")
    model.addConstr(10 * L + R >= 20, name="dollar_cost_LR")
    model.addConstr(6 * P + 10 * L + R >= 20, name="dollar_cost_PLR")
    model.addConstr(-3 * P + 9 * L >= 0, name="Peggy_Laura_ratio")
    model.addConstr(8 * L + 6 * R <= 86, name="org_score_LR_max")
    model.addConstr(2 * P + 6 * R <= 80, name="org_score_PR_max")
    model.addConstr(6 * P + 7 * R <= 30, name="work_quality_PR_max")
    model.addConstr(6 * P + 10 * L <= 78, name="dollar_cost_PL_max")
    model.addConstr(6 * P + R <= 95, name="dollar_cost_PR_max")

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Peggy hours: {P.varValue}")
        print(f"Laura hours: {L.varValue}")
        print(f"Ringo hours: {R.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
