
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
black_beans = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="black_beans")
steaks = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="steaks")

# Objective function: minimize 1*black_beans + 7*steaks
m.setObjective(1*black_beans + 7*steaks, GRB.MINIMIZE)

# Constraints
# Iron constraint: black beans contribute 1 mg each, steaks contribute 9 mg each
m.addConstr(1*black_beans + 9*steaks >= 18, name="iron_min")
m.addConstr(1*black_beans + 9*steaks <= 71, name="iron_max")

# Cost constraint: black beans cost $3 each, steaks cost $7 each
m.addConstr(3*black_beans + 7*steaks >= 22, name="cost_min")
m.addConstr(3*black_beans + 7*steaks <= 45, name="cost_max")

# Fiber constraint: black beans contribute 1 gram each, steaks contribute 3 grams each
m.addConstr(1*black_beans + 3*steaks >= 11, name="fiber_min")
m.addConstr(1*black_beans + 3*steaks <= 28, name="fiber_max")

# Specific linear constraint
m.addConstr(10*black_beans - steaks >= 0, name="specific_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Black beans: {black_beans.x}")
    print(f"Steaks: {steaks.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
