
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    black_beans = model.addVar(name="black_beans", lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS)
    steaks = model.addVar(name="steaks", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 1 * black_beans + 7 * steaks
    model.setObjective(black_beans + 7 * steaks, gurobi.GRB.MINIMIZE)

    # Constraints
    # At least 18 milligrams of iron
    model.addConstraint(black_beans + 9 * steaks >= 18, name="iron_min")
    # At most 71 milligrams of iron
    model.addConstraint(black_beans + 9 * steaks <= 71, name="iron_max")

    # At least $22 cost
    model.addConstraint(3 * black_beans + 7 * steaks >= 22, name="cost_min")
    # At most $45 cost
    model.addConstraint(3 * black_beans + 7 * steaks <= 45, name="cost_max")

    # At least 11 grams of fiber
    model.addConstraint(black_beans + 3 * steaks >= 11, name="fiber_min")
    # At most 28 grams of fiber
    model.addConstraint(black_beans + 3 * steaks <= 28, name="fiber_max")

    # Black beans and steaks relationship
    model.addConstraint(10 * black_beans - steaks >= 0, name="relationship")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Black Beans: {black_beans.varValue}")
        print(f"Steaks: {steaks.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

optimization_problem()
