
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize_Cost")

# Create variables
ringo_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo_hours")
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean_hours")
paul_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="paul_hours")

# Set objective function
model.setObjective(6 * ringo_hours + 1 * jean_hours + 6 * paul_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * ringo_hours == 18 * ringo_hours, "Ringo_likelihood")  # Redundant constraint, included as specified
model.addConstr(6 * ringo_hours == 6 * ringo_hours, "Ringo_cost")        # Redundant constraint, included as specified
model.addConstr(7 * jean_hours == 7 * jean_hours, "Jean_likelihood")      # Redundant constraint, included as specified
model.addConstr(2 * jean_hours == 2 * jean_hours, "Jean_cost")          # Redundant constraint, included as specified
model.addConstr(3 * paul_hours == 3 * paul_hours, "Paul_likelihood")      # Redundant constraint, included as specified
model.addConstr(11 * paul_hours == 11 * paul_hours, "Paul_cost")         # Redundant constraint, included as specified


model.addConstr(7 * jean_hours + 3 * paul_hours >= 15, "Combined_likelihood_Jean_Paul")
model.addConstr(18 * ringo_hours + 7 * jean_hours + 3 * paul_hours >= 24, "Combined_likelihood_all")
model.addConstr(2 * jean_hours + 11 * paul_hours >= 36, "Combined_cost_Jean_Paul")
model.addConstr(6 * ringo_hours + 2 * jean_hours + 11 * paul_hours >= 36, "Combined_cost_all")
model.addConstr(-1 * jean_hours + 1 * paul_hours >= 0, "Jean_Paul_hours_diff")
model.addConstr(2 * jean_hours + 11 * paul_hours <= 111, "Combined_cost_Jean_Paul_upper")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Ringo Hours: %g' % ringo_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

