
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    ringo = model.addVar(name="Ringo", lb=0)  # No upper bound given, assuming 0 is the lower bound
    jean = model.addVar(name="Jean", lb=0)    # No upper bound given, assuming 0 is the lower bound
    paul = model.addVar(name="Paul", lb=0)   # No upper bound given, assuming 0 is the lower bound

    # Objective function: Minimize 6 * Ringo + 1 * Jean + 6 * Paul
    model.setObjective(6 * ringo + 1 * jean + 6 * paul, gurobi.GRB.MINIMIZE)

    # Constraints
    # The likelihood to quit index for Ringo, Jean, and Paul
    r0_ringo = 18 * ringo
    r0_jean = 7 * jean
    r0_paul = 3 * paul

    # The dollar cost per hour for Ringo, Jean, and Paul
    r1_ringo = 6 * ringo
    r1_jean = 2 * jean
    r1_paul = 11 * paul

    # The total combined likelihood to quit index from hours worked by Jean plus hours worked by Paul should be 15 at a minimum.
    model.addConstraint(r0_jean + r0_paul >= 15, name="r0_jean_paul_min")

    # The total combined likelihood to quit index from hours worked by Ringo, Jean, and Paul has to be 24 or more.
    model.addConstraint(r0_ringo + r0_jean + r0_paul >= 24, name="r0_total_min")

    # The total combined dollar cost per hour from hours worked by Jean, and hours worked by Paul must be no less than 36.
    model.addConstraint(r1_jean + r1_paul >= 36, name="r1_jean_paul_min")

    # The total combined dollar cost per hour from hours worked by Ringo plus hours worked by Jean plus hours worked by Paul should be 36 at minimum.
    model.addConstraint(r1_ringo + r1_jean + r1_paul >= 36, name="r1_total_min")

    # minus one times the number of hours worked by Jean, plus 1 times the number of hours worked by Paul must be at minimum zero.
    model.addConstraint(-jean + paul >= 0, name="jean_paul_balance")

    # The total combined dollar cost per hour from hours worked by Jean plus hours worked by Paul has to be  no more than 111.
    model.addConstraint(r1_jean + r1_paul <= 111, name="r1_jean_paul_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Ringo: {ringo.varValue}")
        print(f"Jean: {jean.varValue}")
        print(f"Paul: {paul.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
