
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Peggy")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")

# Objective function: Maximize 7*x0 + 3*x1 + 3*x2
m.setObjective(7*x0 + 3*x1 + 3*x2, GRB.MAXIMIZE)

# Constraints:
# Minimum total productivity rating of 12
m.addConstr(x0 + x1 + 8*x2 >= 12, name="min_productivity")

# Combined paperwork competence ratings constraints
m.addConstr(3*x0 + 2*x2 <= 27, name="paperwork_Peggy_Hank")
m.addConstr(7*x1 + 2*x2 <= 27, name="paperwork_Paul_Hank")
m.addConstr(3*x0 + 7*x1 <= 34, name="paperwork_Peggy_Paul")
m.addConstr(3*x0 + 7*x1 + 2*x2 <= 34, name="paperwork_all")

# Combined productivity ratings constraints
m.addConstr(x1 + 8*x2 <= 29, name="productivity_Paul_Hank")
m.addConstr(x0 + x1 <= 33, name="productivity_Peggy_Paul")
m.addConstr(x0 + x1 + 8*x2 <= 33, name="productivity_all")

# Optimize model
m.optimize()
