
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
kiwis = model.addVar(vtype=GRB.INTEGER, name="kiwis")
cantaloupes = model.addVar(vtype=GRB.INTEGER, name="cantaloupes")
cherry_pies = model.addVar(vtype=GRB.INTEGER, name="cherry_pies")
cornichons = model.addVar(vtype=GRB.CONTINUOUS, name="cornichons")

# Set objective function
model.setObjective(1 * kiwis + 5 * cantaloupes + 7 * cherry_pies + 7 * cornichons, GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * kiwis + 9 * cornichons >= 59, "c1")
model.addConstr(20 * cantaloupes + 2 * cherry_pies >= 42, "c2")
model.addConstr(2 * cherry_pies + 9 * cornichons >= 55, "c3")
model.addConstr(5 * kiwis + 2 * cherry_pies >= 39, "c4")
model.addConstr(5 * kiwis + 20 * cantaloupes + 2 * cherry_pies + 9 * cornichons >= 39, "c5")
model.addConstr(6 * cherry_pies - 3 * cornichons >= 0, "c6")
model.addConstr(-9 * cantaloupes + 2 * cherry_pies >= 0, "c7")


# Carbohydrate constraint (using provided data)
model.addConstr(5 * kiwis + 20 * cantaloupes + 2 * cherry_pies + 9 * cornichons <= 261, "carbohydrate_limit")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kiwis: {kiwis.x}")
    print(f"Cantaloupes: {cantaloupes.x}")
    print(f"Cherry Pies: {cherry_pies.x}")
    print(f"Cornichons: {cornichons.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

