
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="kiwis")
x1 = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")
x2 = m.addVar(vtype=GRB.INTEGER, name="cherry_pies")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="cornichons")

# Objective function
m.setObjective(1*x0 + 5*x1 + 7*x2 + 7*x3, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + 9*x3 >= 59, "carb_kiwis_cornichons")
m.addConstr(20*x1 + 2*x2 >= 42, "carb_cantaloupes_pies")
m.addConstr(2*x2 + 9*x3 >= 55, "carb_pies_cornichons")
m.addConstr(5*x0 + 2*x2 >= 39, "carb_kiwis_pies")
m.addConstr(5*x0 + 20*x1 + 2*x2 + 9*x3 >= 39, "total_carb")
m.addConstr(6*x2 - 3*x3 >= 0, "pies_cornichons_ratio")
m.addConstr(-9*x1 + 2*x2 >= 0, "cantaloupes_pies_ratio")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Kiwis: {x0.x}")
    print(f"Cantaloupes: {x1.x}")
    print(f"Cherry Pies: {x2.x}")
    print(f"Cornichons: {x3.x}")
else:
    print("No optimal solution found")
