
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")

# Set objective function
m.setObjective(7 * vitamin_b5 + 6 * vitamin_c + 2 * vitamin_a + 8 * vitamin_d, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * vitamin_b5 + 9 * vitamin_a + 8 * vitamin_d >= 31, "digestive_constraint1")
m.addConstr(13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d >= 31, "digestive_constraint2")
m.addConstr(13 * vitamin_b5 + 9 * vitamin_a + 8 * vitamin_d >= 30, "digestive_constraint3")
m.addConstr(13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d >= 30, "digestive_constraint4")
m.addConstr(13 * vitamin_b5 + 13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d >= 30, "digestive_constraint5")

m.addConstr(10 * vitamin_b5 + 5 * vitamin_a >= 18, "kidney_constraint1")
m.addConstr(10 * vitamin_b5 + 4 * vitamin_d >= 35, "kidney_constraint2")
m.addConstr(10 * vitamin_b5 + 1 * vitamin_c >= 27, "kidney_constraint3")
m.addConstr(1 * vitamin_c + 5 * vitamin_a >= 12, "kidney_constraint4")
m.addConstr(1 * vitamin_c + 4 * vitamin_d >= 24, "kidney_constraint5")
m.addConstr(10 * vitamin_b5 + 5 * vitamin_a + 4 * vitamin_d >= 25, "kidney_constraint6")
m.addConstr(10 * vitamin_b5 + 1 * vitamin_c + 5 * vitamin_a + 4 * vitamin_d >= 25, "kidney_constraint7")


m.addConstr(-10 * vitamin_b5 + 7 * vitamin_a >= 0, "constraint1")
m.addConstr(2 * vitamin_c - 6 * vitamin_d >= 0, "constraint2")

m.addConstr(13 * vitamin_b5 + 13 * vitamin_c <= 83, "digestive_constraint6")
m.addConstr(13 * vitamin_b5 + 8 * vitamin_d <= 141, "digestive_constraint7")
m.addConstr(13 * vitamin_b5 + 9 * vitamin_a <= 133, "digestive_constraint8")
m.addConstr(13 * vitamin_b5 + 13 * vitamin_c + 8 * vitamin_d <= 91, "digestive_constraint9")
m.addConstr(13 * vitamin_b5 + 13 * vitamin_c + 9 * vitamin_a <= 132, "digestive_constraint10")
m.addConstr(13 * vitamin_c + 9 * vitamin_a + 8 * vitamin_d <= 145, "digestive_constraint11")

m.addConstr(10 * vitamin_b5 + 5 * vitamin_a <= 111, "kidney_constraint8")
m.addConstr(5 * vitamin_a + 4 * vitamin_d <= 124, "kidney_constraint9")
m.addConstr(10 * vitamin_b5 + 4 * vitamin_d <= 63, "kidney_constraint10")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

