
import gurobi

def optimize_vitamins():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    vitamin_B5 = model.addVar(name="vitamin_B5", lb=0)
    vitamin_C = model.addVar(name="vitamin_C", lb=0)
    vitamin_A = model.addVar(name="vitamin_A", lb=0)
    vitamin_D = model.addVar(name="vitamin_D", lb=0)

    # Objective function
    model.setObjective(7 * vitamin_B5 + 6 * vitamin_C + 2 * vitamin_A + 8 * vitamin_D, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13 * vitamin_B5 <= 157)
    model.addConstr(10 * vitamin_B5 <= 143)
    model.addConstr(13 * vitamin_C <= 157)
    model.addConstr(vitamin_C <= 143)
    model.addConstr(9 * vitamin_A <= 157)
    model.addConstr(5 * vitamin_A <= 143)
    model.addConstr(8 * vitamin_D <= 157)
    model.addConstr(4 * vitamin_D <= 143)

    model.addConstr(13 * vitamin_B5 + 9 * vitamin_A + 8 * vitamin_D >= 31)
    model.addConstr(13 * vitamin_C + 9 * vitamin_A + 8 * vitamin_D >= 31)
    model.addConstr(13 * vitamin_B5 + 9 * vitamin_A + 8 * vitamin_D >= 30)
    model.addConstr(13 * vitamin_C + 9 * vitamin_A + 8 * vitamin_D >= 30)
    model.addConstr(13 * vitamin_B5 + 13 * vitamin_C + 9 * vitamin_A + 8 * vitamin_D >= 30)

    model.addConstr(10 * vitamin_B5 + 5 * vitamin_A >= 18)
    model.addConstr(10 * vitamin_B5 + 4 * vitamin_D >= 35)
    model.addConstr(10 * vitamin_B5 + vitamin_C >= 27)
    model.addConstr(vitamin_C + 5 * vitamin_A >= 12)
    model.addConstr(vitamin_C + 4 * vitamin_D >= 24)
    model.addConstr(10 * vitamin_B5 + 5 * vitamin_A + 4 * vitamin_D >= 25)
    model.addConstr(10 * vitamin_B5 + vitamin_C + 5 * vitamin_A + 4 * vitamin_D >= 25)

    model.addConstr(-10 * vitamin_B5 + 7 * vitamin_A >= 0)
    model.addConstr(2 * vitamin_C - 6 * vitamin_D >= 0)

    model.addConstr(13 * vitamin_B5 + 13 * vitamin_C <= 83)
    model.addConstr(13 * vitamin_B5 + 8 * vitamin_D <= 141)
    model.addConstr(13 * vitamin_B5 + 9 * vitamin_A <= 133)
    model.addConstr(13 * vitamin_B5 + 13 * vitamin_C + 8 * vitamin_D <= 91)
    model.addConstr(13 * vitamin_B5 + 13 * vitamin_C + 9 * vitamin_A <= 132)
    model.addConstr(13 * vitamin_C + 9 * vitamin_A + 8 * vitamin_D <= 145)

    model.addConstr(10 * vitamin_B5 + 5 * vitamin_A <= 111)
    model.addConstr(5 * vitamin_A + 4 * vitamin_D <= 124)
    model.addConstr(10 * vitamin_B5 + 4 * vitamin_D <= 63)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vitamin B5: {vitamin_B5.varValue}")
        print(f"Vitamin C: {vitamin_C.varValue}")
        print(f"Vitamin A: {vitamin_A.varValue}")
        print(f"Vitamin D: {vitamin_D.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
