
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
hank_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
ringo_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo_hours")
jean_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")
mary_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mary_hours")

# Set objective function
model.setObjective(9.17 * hank_hours + 1.52 * ringo_hours + 4.32 * jean_hours + 7.39 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(11 * hank_hours + 7 * jean_hours >= 14, "c1")
model.addConstr(7 * ringo_hours + 7 * jean_hours >= 11, "c2")
model.addConstr(11 * hank_hours + 7 * ringo_hours + 3 * mary_hours >= 15, "c3")
model.addConstr(9 * hank_hours + 3 * ringo_hours >= 26, "c4")
model.addConstr(9 * hank_hours + 6 * jean_hours >= 14, "c5")
model.addConstr(2 * jean_hours + 7 * mary_hours >= 56, "c6")
model.addConstr(2 * jean_hours + 5 * mary_hours <= 28, "c7")
model.addConstr(9 * hank_hours + 2 * jean_hours <= 63, "c8")
model.addConstr(4 * ringo_hours + 5 * mary_hours <= 79, "c9")
model.addConstr(9 * hank_hours + 4 * ringo_hours <= 63, "c10")
model.addConstr(9 * hank_hours + 4 * ringo_hours + 2 * jean_hours + 5 * mary_hours <= 63, "c11")
model.addConstr(7 * jean_hours + 3 * mary_hours <= 16, "c12")
model.addConstr(11 * hank_hours + 7 * ringo_hours <= 25, "c13")
model.addConstr(11 * hank_hours + 7 * ringo_hours + 7 * jean_hours + 3 * mary_hours <= 25, "c14")
model.addConstr(6 * jean_hours + 10 * mary_hours <= 44, "c15")
model.addConstr(9 * hank_hours + 10 * mary_hours <= 102, "c16")
model.addConstr(9 * hank_hours + 6 * jean_hours <= 100, "c17")
model.addConstr(9 * hank_hours + 3 * ringo_hours + 6 * jean_hours + 10 * mary_hours <= 100, "c18")
model.addConstr(2 * hank_hours + 7 * mary_hours <= 115, "c19")
model.addConstr(2 * jean_hours + 7 * mary_hours <= 75, "c20")
model.addConstr(4 * ringo_hours + 2 * jean_hours <= 84, "c21")
model.addConstr(2 * hank_hours + 2 * jean_hours <= 111, "c22")
model.addConstr(4 * ringo_hours + 7 * mary_hours <= 105, "c23")
model.addConstr(2 * hank_hours + 4 * ringo_hours + 2 * jean_hours + 7 * mary_hours <= 105, "c24")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

