
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
H = m.addVar(lb=0, name="H")  # continuous
R = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="R")  # integer
J = m.addVar(lb=0, name="J")  # continuous
M = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="M")  # integer

# Define the objective function
m.setObjective(9.17*H + 1.52*R + 4.32*J + 7.39*M, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*H + 4*R + 2*J + 5*M <= 102)
m.addConstr(11*H + 7*R + 7*J + 3*M <= 61)
m.addConstr(9*H + 3*R + 6*J + 10*M <= 138)
m.addConstr(2*H + 4*R + 2*J + 7*M <= 225)
m.addConstr(11*H + 7*J >= 14)
m.addConstr(7*R + 7*J >= 11)
m.addConstr(11*H + 7*R + 3*M >= 15)
m.addConstr(9*H + 3*R >= 26)
m.addConstr(9*H + 6*J >= 14)
m.addConstr(2*J + 7*M >= 56)
m.addConstr(2*J + 5*M <= 28)
m.addConstr(9*H + 2*J <= 63)
m.addConstr(4*R + 5*M <= 79)
m.addConstr(9*H + 4*R <= 63)
m.addConstr(9*H + 4*R + 2*J + 5*M <= 63)
m.addConstr(7*J + 3*M <= 16)
m.addConstr(11*H + 7*R <= 25)
m.addConstr(11*H + 7*R + 7*J + 3*M <= 25)
m.addConstr(6*J + 10*M <= 44)
m.addConstr(9*H + 10*M <= 102)
m.addConstr(9*H + 6*J <= 100)
m.addConstr(9*H + 3*R + 6*J + 10*M <= 100)
m.addConstr(2*H + 7*M <= 115)
m.addConstr(2*J + 7*M <= 75)
m.addConstr(4*R + 2*J <= 84)
m.addConstr(2*H + 2*J <= 111)
m.addConstr(4*R + 7*M <= 105)
m.addConstr(2*H + 4*R + 2*J + 7*M <= 105)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("H: ", H.varValue)
    print("R: ", R.varValue)
    print("J: ", J.varValue)
    print("M: ", M.varValue)
else:
    print("The model is infeasible")
