
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_iron_optimization")

# Create variables
vitamin_d = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_d")
iron = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")

# Set objective function
model.setObjective(vitamin_d + 8 * iron, GRB.MAXIMIZE)

# Add constraints
model.addConstr(17 * vitamin_d + 1 * iron >= 48, "kidney_support_min")
model.addConstr(-9 * vitamin_d + 1 * iron >= 0, "constraint2")
model.addConstr(17 * vitamin_d + 1 * iron <= 74, "kidney_support_max") # Redundant given kidney_support_equal
model.addConstr(17 * vitamin_d + 1 * iron == 74, "kidney_support_equal")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Milligrams of Vitamin D: {vitamin_d.x}")
    print(f"  Milligrams of Iron: {iron.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

