
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
vitamin_D = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")
iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_iron")

# Set the objective function: maximize 1 * vitamin_D + 8 * iron
m.setObjective(1 * vitamin_D + 8 * iron, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17 * vitamin_D + 1 * iron >= 48, name="kidney_support_index_min")
m.addConstr(-9 * vitamin_D + 1 * iron >= 0, name="vitamin_d_iron_ratio")
m.addConstr(17 * vitamin_D + 1 * iron <= 74, name="kidney_support_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin D: {vitamin_D.x}")
    print(f"Milligrams of Iron: {iron.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
