
from gurobipy import Model, GRB

# Create a new model
m = Model("Work Optimization")

# Create variables
ringo = m.addVar(vtype=GRB.CONTINUOUS, name="hours worked by Ringo")
jean = m.addVar(vtype=GRB.CONTINUOUS, name="hours worked by Jean")
hank = m.addVar(vtype=GRB.CONTINUOUS, name="hours worked by Hank")
peggy = m.addVar(vtype=GRB.INTEGER, name="hours worked by Peggy")

# Set objective function
m.setObjective(3 * ringo + 5 * jean + 8 * hank + 9 * peggy, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * jean + 6 * peggy >= 51, "c1")
m.addConstr(15 * ringo + 10 * jean + 4 * hank >= 58, "c2")
m.addConstr(15 * ringo + 10 * jean + 6 * peggy >= 58, "c3")
m.addConstr(10 * jean + 4 * hank + 6 * peggy >= 58, "c4")
m.addConstr(15 * ringo + 10 * jean + 4 * hank >= 69, "c5")
m.addConstr(15 * ringo + 10 * jean + 6 * peggy >= 69, "c6")
m.addConstr(10 * jean + 4 * hank + 6 * peggy >= 69, "c7")
m.addConstr(15 * ringo + 10 * jean + 4 * hank >= 57, "c8")
m.addConstr(15 * ringo + 10 * jean + 6 * peggy >= 57, "c9")
m.addConstr(10 * jean + 4 * hank + 6 * peggy >= 57, "c10")
m.addConstr(17 * jean + 13 * peggy >= 62, "c11")
m.addConstr(1 * hank + 13 * peggy >= 59, "c12")
m.addConstr(17 * jean + 1 * hank >= 80, "c13")
m.addConstr(6 * ringo + 17 * jean + 13 * peggy >= 77, "c14")
m.addConstr(17 * jean + 1 * hank + 13 * peggy >= 77, "c15")
m.addConstr(6 * ringo + 17 * jean + 13 * peggy >= 59, "c16")
m.addConstr(17 * jean + 1 * hank + 13 * peggy >= 59, "c17")
m.addConstr(6 * jean + 9 * hank - 9 * peggy >= 0, "c18")
m.addConstr(10 * jean + 4 * hank <= 165, "c19")
m.addConstr(15 * ringo + 10 * jean <= 445, "c20")
m.addConstr(15 * ringo + 4 * hank <= 380, "c21")
m.addConstr(10 * jean + 6 * peggy <= 153, "c22")
m.addConstr(15 * ringo + 6 * peggy <= 120, "c23")
m.addConstr(4 * hank + 6 * peggy <= 258, "c24")
m.addConstr(15 * ringo + 10 * jean + 4 * hank + 6 * peggy <= 258, "c25")
m.addConstr(6 * ringo + 17 * jean <= 243, "c26")
m.addConstr(6 * ringo + 13 * peggy <= 220, "c27")
m.addConstr(17 * jean + 13 * peggy <= 112, "c28")
m.addConstr(1 * hank + 13 * peggy <= 201, "c29")
m.addConstr(6 * ringo + 17 * jean + 13 * peggy <= 159, "c30")
m.addConstr(17 * jean + 1 * hank + 13 * peggy <= 303, "c31")
m.addConstr(6 * ringo + 17 * jean + 1 * hank + 13 * peggy <= 303, "c32")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

