
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
R = m.addVar(lb=0, name="Ringo_hours")
J = m.addVar(lb=0, name="Jean_hours")
H = m.addVar(lb=0, name="Hank_hours")
P = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Peggy_hours")

# Objective function
m.setObjective(3*R + 5*J + 8*H + 9*P, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(10*J + 6*P >= 51)
m.addConstr(15*R + 10*J + 4*H >= 58)
m.addConstr(15*R + 10*J + 6*P >= 58)
m.addConstr(10*J + 4*H + 6*P >= 58)
m.addConstr(15*R + 10*J + 4*H >= 69)
m.addConstr(15*R + 10*J + 6*P >= 69)
m.addConstr(10*J + 4*H + 6*P >= 69)
m.addConstr(15*R + 10*J + 4*H >= 57)
m.addConstr(15*R + 10*J + 6*P >= 57)
m.addConstr(10*J + 4*H + 6*P >= 57)
m.addConstr(17*J + 13*P >= 62)
m.addConstr(1*H + 13*P >= 59)
m.addConstr(17*J + 1*H >= 80)
m.addConstr(6*R + 17*J + 13*P >= 77)
m.addConstr(17*J + 1*H + 13*P >= 77)
m.addConstr(6*R + 17*J + 13*P >= 59)
m.addConstr(17*J + 1*H + 13*P >= 59)
m.addConstr(6*J + 9*H - 9*P >= 0)
m.addConstr(10*J + 4*H <= 165)
m.addConstr(15*R + 10*J <= 447)
m.addConstr(15*R + 4*H <= 380)
m.addConstr(10*J + 6*P <= 153)
m.addConstr(15*R + 6*P <= 120)
m.addConstr(4*H + 6*P <= 258)
m.addConstr(15*R + 10*J + 4*H + 6*P <= 447)
m.addConstr(6*R + 17*J <= 243)
m.addConstr(6*R + 13*P <= 220)
m.addConstr(17*J + 13*P <= 112)
m.addConstr(1*H + 13*P <= 201)
m.addConstr(6*R + 17*J + 13*P <= 159)
m.addConstr(17*J + 1*H + 13*P <= 303)
m.addConstr(6*R + 17*J + 1*H + 13*P <= 303)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ringo hours: ", R.varValue)
    print("Jean hours: ", J.varValue)
    print("Hank hours: ", H.varValue)
    print("Peggy hours: ", P.varValue)
else:
    print("The model is infeasible")
