
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
magnesium = m.addVar(lb=0, name="magnesium")
vitamin_b1 = m.addVar(lb=0, name="vitamin_b1")
vitamin_k = m.addVar(lb=0, name="vitamin_k")

# Set objective function
m.setObjective(3.78 * magnesium + 8.9 * vitamin_b1 + 5.8 * vitamin_k, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * magnesium + 6 * vitamin_k >= 36, "c1")
m.addConstr(13 * magnesium + 4 * vitamin_b1 >= 22, "c2")
m.addConstr(13 * magnesium + 4 * vitamin_b1 + 6 * vitamin_k >= 53, "c3")
m.addConstr(6 * magnesium - 2 * vitamin_b1 >= 0, "c4")
m.addConstr(3 * vitamin_b1 - 9 * vitamin_k >= 0, "c5")
m.addConstr(13 * magnesium + 4 * vitamin_b1 <= 89, "c6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Magnesium: {magnesium.x}")
    print(f"Vitamin B1: {vitamin_b1.x}")
    print(f"Vitamin K: {vitamin_k.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

