
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
milligrams_magnesium = m.addVar(name='milligrams_of_magnesium', lb=0)
milligrams_vitamin_b1 = m.addVar(name='milligrams_of_vitamin_B1', lb=0)
milligrams_vitamin_k = m.addVar(name='milligrams_of_vitamin_K', lb=0)

# Define the objective function
m.setObjective(3.78 * milligrams_magnesium + 8.9 * milligrams_vitamin_b1 + 5.8 * milligrams_vitamin_k, GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * milligrams_magnesium + 6 * milligrams_vitamin_k >= 36, name='constraint_4')
m.addConstr(13 * milligrams_magnesium + 4 * milligrams_vitamin_b1 >= 22, name='constraint_5')
m.addConstr(13 * milligrams_magnesium + 4 * milligrams_vitamin_b1 + 6 * milligrams_vitamin_k >= 53, name='constraint_6')
m.addConstr(13 * milligrams_magnesium + 4 * milligrams_vitamin_b1 <= 89, name='constraint_9')
m.addConstr(6 * milligrams_magnesium - 2 * milligrams_vitamin_b1 >= 0, name='constraint_7')
m.addConstr(3 * milligrams_vitamin_b1 - 9 * milligrams_vitamin_k >= 0, name='constraint_8')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Milligrams of Magnesium: {milligrams_magnesium.x}')
    print(f'Milligrams of Vitamin B1: {milligrams_vitamin_b1.x}')
    print(f'Milligrams of Vitamin K: {milligrams_vitamin_k.x}')
    print(f'Objective Function Value: {m.objVal}')
else:
    print('No optimal solution found')
