
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=0, name="milligrams of magnesium", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, name="milligrams of vitamin B1", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="milligrams of vitamin K", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(3.78*x0 + 8.9*x1 + 5.8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13*x0 + 6*x2 >= 36, name="immune_support_magnesium_K")
    model.addConstr(13*x0 + 4*x1 >= 22, name="immune_support_magnesium_B1")
    model.addConstr(13*x0 + 4*x1 + 6*x2 >= 53, name="immune_support_total")
    model.addConstr(6*x0 - 2*x1 >= 0, name="magnesium_B1_ratio")
    model.addConstr(3*x1 - 9*x2 >= 0, name="B1_K_ratio")
    model.addConstr(13*x0 + 4*x1 <= 89, name="immune_support_magnesium_B1_limit")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of magnesium: {x0.varValue}")
        print(f"Milligrams of vitamin B1: {x1.varValue}")
        print(f"Milligrams of vitamin K: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
