
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")
oranges = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")
pizza_slices = m.addVar(vtype=GRB.INTEGER, name="pizza_slices")

# Set objective function
m.setObjective(3.42 * green_beans * oranges + 7.77 * oranges * pizza_slices + 6.09 * pizza_slices * pizza_slices + 3.32 * green_beans + 2.66 * oranges, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * green_beans + 16 * oranges + 20 * pizza_slices <= 107, "dollar_cost")  # Total cost constraint
m.addConstr(5 * green_beans + 16 * oranges + 7 * pizza_slices <= 113, "tastiness_rating")  # Total tastiness constraint
m.addConstr(4 * green_beans**2 + 20 * pizza_slices**2 >= 21, "cost_squared_1")  # Cost squared constraint 1
m.addConstr(16 * oranges**2 + 20 * pizza_slices**2 >= 23, "cost_squared_2")  # Cost squared constraint 2
m.addConstr(4 * green_beans + 16 * oranges >= 11, "cost_gb_oranges")  # Cost of green beans and oranges
m.addConstr(4 * green_beans + 16 * oranges + 20 * pizza_slices >= 23, "total_cost_lower_bound")  # Total cost lower bound
m.addConstr(5 * green_beans + 16 * oranges >= 37, "tastiness_gb_oranges")  # Tastiness of green beans and oranges
m.addConstr(16 * oranges + 7 * pizza_slices >= 20, "tastiness_oranges_pizza")  # Tastiness of oranges and pizza
m.addConstr(5 * green_beans + 16 * oranges + 7 * pizza_slices >= 25, "total_tastiness_lower_bound")  # Total tastiness lower bound
m.addConstr(2 * green_beans - 10 * pizza_slices >= 0, "gb_pizza_relation")  # Green beans and pizza relation
m.addConstr(5 * green_beans + 7 * pizza_slices <= 68, "tastiness_gb_pizza")  # Tastiness of green beans and pizza
m.addConstr(16 * oranges**2 + 7 * pizza_slices**2 <= 99, "tastiness_squared") # Tastiness squared constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('green_beans:', green_beans.x)
    print('oranges:', oranges.x)
    print('pizza_slices:', pizza_slices.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

