
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="green_beans", vtype=gp.GRB.INTEGER)  # green beans
x1 = m.addVar(name="oranges", vtype=gp.GRB.CONTINUOUS)  # oranges
x2 = m.addVar(name="slices_of_pizza", vtype=gp.GRB.INTEGER)  # slices of pizza

# Objective function
m.setObjective(3.42*x0*x1 + 7.77*x1*x2 + 6.09*x2**2 + 3.32*x0 + 2.66*x1, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(4*x0 + 16*x1 + 20*x2 <= 107, name="budget_constraint")
m.addConstr(5*x0 + 16*x1 + 7*x2 <= 113, name="tastiness_rating_constraint")
m.addConstr(x0**2 + x2**2 >= 21, name="green_beans_and_pizza_squared_cost")
m.addConstr(x1**2 + x2**2 >= 23, name="oranges_and_pizza_squared_cost")
m.addConstr(4*x0 + 16*x1 >= 11, name="green_beans_and_oranges_min_spend")
m.addConstr(4*x0 + 16*x1 + 20*x2 >= 23, name="total_min_spend")
m.addConstr(5*x0 + 16*x1 >= 37, name="green_beans_and_oranges_tastiness")
m.addConstr(16*x1 + 7*x2 >= 20, name="oranges_and_pizza_tastiness")
m.addConstr(5*x0 + 16*x1 + 7*x2 >= 25, name="total_tastiness_rating")
m.addConstr(2*x0 - 10*x2 >= 0, name="green_beans_and_pizza_relation")
m.addConstr(5*x0 + 7*x2 <= 68, name="green_beans_and_pizza_tastiness_limit")
m.addConstr(16**2*x1**2 + 7**2*x2**2 <= 99, name="oranges_and_pizza_tastiness_squared_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Green Beans: {x0.varValue}")
    print(f"Oranges: {x1.varValue}")
    print(f"Slices of Pizza: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
