
from gurobipy import Model, GRB

# Create a new model
m = Model("Vine Optimization")

# Create variables
zucchini = m.addVar(vtype=GRB.INTEGER, name="zucchini")
cucumber = m.addVar(vtype=GRB.INTEGER, name="cucumber")

# Set objective function
m.setObjective(2.44 * zucchini + 6.82 * cucumber, GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * zucchini + 15 * cucumber >= 66, "Resilience_min")
m.addConstr(8 * zucchini + 15 * cucumber <= 159, "Resilience_max")  # Using the provided upper bound

m.addConstr(6 * zucchini + 1 * cucumber >= 66, "Planting_min") # Assuming planting space is in sq. in.
m.addConstr(6 * zucchini + 1 * cucumber <= 172, "Planting_max") # Using the provided upper bound


m.addConstr(8 * zucchini - 3 * cucumber >= 0, "Zucchini_Cucumber_Ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Zucchini Vines:', zucchini.x)
    print('Cucumber Vines:', cucumber.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

