
from gurobipy import *

# Create a new model
m = Model("Vines_Optimization")

# Define variables
z = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
c = m.addVar(vtype=GRB.INTEGER, name="cucumber_vines")

# Objective function: Minimize 2.44*z + 6.82*c
m.setObjective(2.44*z + 6.82*c, GRB.MINIMIZE)

# Constraints
m.addConstr(8*z + 15*c >= 66, "resilience_min")
m.addConstr(6*z + c >= 66, "space_min")
m.addConstr(8*z - 3*c >= 0, "additional_constraint")
m.addConstr(8*z + 15*c <= 159, "resilience_max")
m.addConstr(6*z + c <= 172, "space_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Zucchini Vines: {z.x}")
    print(f"Cucumber Vines: {c.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
