
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    zucchini_vines = model.addVar(name="zucchini_vines", vtype=gurobi.GRB.INTEGER)
    cucumber_vines = model.addVar(name="cucumber_vines", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(2.44 * zucchini_vines + 6.82 * cucumber_vines, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * zucchini_vines + 15 * cucumber_vines >= 66, name="resilience_index_min")
    model.addConstr(8 * zucchini_vines + 15 * cucumber_vines <= 159, name="resilience_index_max")
    model.addConstr(6 * zucchini_vines + 1 * cucumber_vines >= 66, name="planting_space_min")
    model.addConstr(6 * zucchini_vines + 1 * cucumber_vines <= 172, name="planting_space_max")
    model.addConstr(8 * zucchini_vines - 3 * cucumber_vines >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Zucchini vines: {zucchini_vines.varValue}")
        print(f"Cucumber vines: {cucumber_vines.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution found.")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
