
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
peggy_hours = m.addVar(name="peggy_hours", lb=0)  # No upper bound given, assuming 0 is lower bound
hank_hours = m.addVar(name="hank_hours", lb=0)  # No upper bound given, assuming 0 is lower bound
george_hours = m.addVar(name="george_hours", lb=0)  # No upper bound given, assuming 0 is lower bound

# Objective function
m.setObjective(8 * peggy_hours * hank_hours + george_hours ** 2 + peggy_hours, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(peggy_hours >= 0)  # Implicit, but for clarity
m.addConstr(hank_hours >= 0)  # Implicit, but for clarity
m.addConstr(george_hours >= 0)  # Implicit, but for clarity

# Constraint 7
m.addConstr(hank_hours ** 2 + george_hours ** 2 >= 28)

# Constraint 8
m.addConstr(peggy_hours + hank_hours + george_hours >= 28)

# Constraint 9
m.addConstr(hank_hours + george_hours >= 23)

# Constraint 10
m.addConstr(peggy_hours ** 2 + george_hours ** 2 >= 24)

# Constraint 11
m.addConstr(peggy_hours ** 2 + hank_hours ** 2 + george_hours ** 2 >= 21)

# Constraint 12
m.addConstr(peggy_hours + hank_hours + george_hours >= 21)

# Constraint 13
m.addConstr(9 * peggy_hours ** 2 - 7 * hank_hours ** 2 >= 0)

# Constraint 14
m.addConstr(peggy_hours + george_hours <= 79)

# Constraint 15
m.addConstr(hank_hours ** 2 + george_hours ** 2 <= 58)

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Peggy's hours: {peggy_hours.varValue}")
    print(f"Hank's hours: {hank_hours.varValue}")
    print(f"George's hours: {george_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
