
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    packs_of_napkins = model.addVar(name="packs_of_napkins", integer=True)
    dish_soap_bottles = model.addVar(name="dish_soap_bottles", integer=True)
    paper_towel_rolls = model.addVar(name="paper_towel_rolls", integer=True)
    toilet_paper_rolls = model.addVar(name="toilet_paper_rolls", integer=True)

    # Objective function
    model.setObjective(10.0 * packs_of_napkins + 6.84 * dish_soap_bottles + 5.05 * paper_towel_rolls + 1.44 * toilet_paper_rolls, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * packs_of_napkins + 4 * dish_soap_bottles + 3 * paper_towel_rolls + 6 * toilet_paper_rolls <= 97, "storage_space")
    model.addConstr(paper_towel_rolls + toilet_paper_rolls >= 14, "min_paper_towel_toilet_paper_space")
    model.addConstr(dish_soap_bottles + paper_towel_rolls >= 18, "min_dish_soap_paper_towel_space")
    model.addConstr(packs_of_napkins + paper_towel_rolls >= 24, "min_packs_paper_towel_space")
    model.addConstr(packs_of_napkins + dish_soap_bottles >= 11, "min_packs_dish_soap_space")
    model.addConstr(packs_of_napkins + dish_soap_bottles + paper_towel_rolls + toilet_paper_rolls >= 11, "min_total_space")
    model.addConstr(-7 * packs_of_napkins + 8 * paper_towel_rolls >= 0, "packs_paper_towel_relation")
    model.addConstr(packs_of_napkins + dish_soap_bottles <= 62, "max_packs_dish_soap_space")
    model.addConstr(packs_of_napkins + dish_soap_bottles + paper_towel_rolls <= 73, "max_packs_dish_soap_paper_towel_space")
    model.addConstr(packs_of_napkins + dish_soap_bottles + toilet_paper_rolls <= 96, "max_packs_dish_soap_toilet_paper_space")
    model.addConstr(dish_soap_bottles + paper_towel_rolls + toilet_paper_rolls <= 59, "max_dish_soap_paper_towel_toilet_paper_space")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Packs of napkins: ", packs_of_napkins.varValue)
        print("Dish soap bottles: ", dish_soap_bottles.varValue)
        print("Paper towel rolls: ", paper_towel_rolls.varValue)
        print("Toilet paper rolls: ", toilet_paper_rolls.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
