
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
bobby = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
jean = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Jean")
dale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")

# Set objective function
m.setObjective(8*paul + 6*bobby + 2*peggy + 5*jean + 3*dale, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*paul + 14*bobby + 10*peggy >= 32, "c0")
m.addConstr(11*paul + 10*peggy <= 123, "c1")
m.addConstr(14*bobby + 5*dale <= 87, "c2")
m.addConstr(14*bobby + 10*peggy <= 151, "c3")
m.addConstr(10*peggy + 5*dale <= 143, "c4")
m.addConstr(11*paul + 5*dale <= 125, "c5")
m.addConstr(11*paul + 10*jean + 5*dale <= 82, "c6")
m.addConstr(11*paul + 14*bobby + 10*peggy + 10*jean + 5*dale <= 82, "c7")
m.addConstr(14*bobby + 10*jean <= 221, "c8")
m.addConstr(10*jean + 1*dale <= 326, "c9")
m.addConstr(12*paul + 14*bobby + 11*peggy + 10*jean + 1*dale <= 326, "c10")
m.addConstr(6*paul + 7*jean <= 77, "c11")
m.addConstr(3*peggy + 7*jean <= 62, "c12")
m.addConstr(7*jean + 8*dale <= 75, "c13")
m.addConstr(6*paul + 3*peggy <= 84, "c14")
m.addConstr(6*bobby + 3*peggy <= 37, "c15")
m.addConstr(6*paul + 8*dale <= 60, "c16")
m.addConstr(3*peggy + 7*jean + 8*dale <= 40, "c17")
m.addConstr(6*bobby + 3*peggy + 8*dale <= 77, "c18")
m.addConstr(6*bobby + 3*peggy + 7*jean <= 76, "c19")
m.addConstr(6*paul + 3*peggy + 8*dale <= 52, "c20")
m.addConstr(6*paul + 3*peggy + 7*jean <= 33, "c21")
m.addConstr(6*bobby + 7*jean + 8*dale <= 17, "c22")
m.addConstr(6*paul + 6*bobby + 3*peggy + 7*jean + 8*dale <= 17, "c23")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

