
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Paul", lb=0)
x1 = m.addVar(name="hours_worked_by_Bobby", lb=0)
x2 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x3 = m.addVar(name="hours_worked_by_Jean", lb=0, integrality=gp.GRB.Integer)
x4 = m.addVar(name="hours_worked_by_Dale", lb=0)

# Define the objective function
m.setObjective(8*x0 + 6*x1 + 2*x2 + 5*x3 + 3*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 + 14*x1 + 10*x2 >= 32)
m.addConstr(11*x0 + 10*x2 <= 123)
m.addConstr(14*x1 + 5*x4 <= 87)
m.addConstr(14*x1 + 10*x2 <= 151)
m.addConstr(10*x2 + 5*x4 <= 143)
m.addConstr(11*x0 + 5*x4 <= 125)
m.addConstr(11*x0 + 10*x3 + 5*x4 <= 82)
m.addConstr(11*x0 + 14*x1 + 10*x2 + 10*x3 + 5*x4 <= 82)
m.addConstr(14*x1 + 10*x3 <= 221)
m.addConstr(10*x3 + x4 <= 326)
m.addConstr(12*x0 + 14*x1 + 11*x2 + 10*x3 + x4 <= 326)
m.addConstr(6*x0 + 7*x3 <= 77)
m.addConstr(3*x2 + 7*x3 <= 62)
m.addConstr(7*x3 + 8*x4 <= 75)
m.addConstr(6*x0 + 3*x2 <= 84)
m.addConstr(6*x1 + 3*x2 <= 37)
m.addConstr(6*x0 + 8*x4 <= 60)
m.addConstr(3*x2 + 7*x3 + 8*x4 <= 40)
m.addConstr(6*x1 + 3*x2 + 8*x4 <= 77)
m.addConstr(6*x1 + 3*x2 + 7*x3 <= 76)
m.addConstr(6*x0 + 3*x2 + 8*x4 <= 52)
m.addConstr(6*x0 + 3*x2 + 7*x3 <= 33)
m.addConstr(6*x1 + 7*x3 + 8*x4 <= 17)
m.addConstr(6*x0 + 6*x1 + 3*x2 + 7*x3 + 8*x4 <= 17)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Paul: ", x0.varValue)
    print("Hours worked by Bobby: ", x1.varValue)
    print("Hours worked by Peggy: ", x2.varValue)
    print("Hours worked by Jean: ", x3.varValue)
    print("Hours worked by Dale: ", x4.varValue)
else:
    print("The model is infeasible")
