
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cereal")
sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sandwiches")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chickens")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")

# Set objective function
m.setObjective(5*cereal + 1*sandwiches + 6*apples + 9*chickens + 7*oreos, gp.GRB.MINIMIZE)

# Add sourness index constraints
m.addConstr(1.75*sandwiches + 1.88*oreos >= 14, "sourness_constraint1")
m.addConstr(0.12*cereal + 1.88*oreos >= 21, "sourness_constraint2")
m.addConstr(0.12*cereal + 0.18*chickens >= 23, "sourness_constraint3")
m.addConstr(0.12*cereal + 1.75*sandwiches >= 32, "sourness_constraint4")
m.addConstr(1.66*apples + 0.18*chickens + 1.88*oreos >= 33, "sourness_constraint5")
m.addConstr(0.12*cereal + 1.75*sandwiches + 1.66*apples + 0.18*chickens + 1.88*oreos >= 33, "sourness_constraint6")
m.addConstr(0.12*cereal + 1.88*oreos <= 110, "sourness_constraint7")
m.addConstr(1.75*sandwiches + 0.18*chickens + 1.88*oreos <= 89, "sourness_constraint8")
m.addConstr(1.75*sandwiches + 1.66*apples + 0.18*chickens <= 166, "sourness_constraint9")
m.addConstr(1.75*sandwiches + 1.66*apples + 1.88*oreos <= 50, "sourness_constraint10")
m.addConstr(0.12*cereal + 1.75*sandwiches + 0.18*chickens <= 55, "sourness_constraint11")
m.addConstr(0.12*cereal + 1.66*apples + 1.88*oreos <= 74, "sourness_constraint12")


# Add umami index constraints
m.addConstr(0.13*cereal + 0.97*oreos >= 42, "umami_constraint1")
m.addConstr(0.04*chickens + 0.97*oreos >= 35, "umami_constraint2")
m.addConstr(1.43*apples + 0.04*chickens >= 35, "umami_constraint3")
m.addConstr(0.75*sandwiches + 0.97*oreos >= 31, "umami_constraint4")
m.addConstr(0.13*cereal + 0.04*chickens + 0.97*oreos >= 44, "umami_constraint5")
m.addConstr(0.13*cereal + 0.75*sandwiches + 1.43*apples >= 44, "umami_constraint6")
m.addConstr(0.13*cereal + 0.04*chickens + 0.97*oreos >= 42, "umami_constraint7")
m.addConstr(0.13*cereal + 0.75*sandwiches + 1.43*apples >= 42, "umami_constraint8")
m.addConstr(0.13*cereal + 0.75*sandwiches + 1.43*apples + 0.04*chickens + 0.97*oreos >= 42, "umami_constraint9")
m.addConstr(0.13*cereal + 0.75*sandwiches + 0.97*oreos <= 226, "umami_constraint10")
m.addConstr(0.75*sandwiches + 1.43*apples + 0.97*oreos <= 196, "umami_constraint11")
m.addConstr(0.13*cereal + 0.04*chickens + 0.97*oreos <= 82, "umami_constraint12")
m.addConstr(1.43*apples + 0.04*chickens + 0.97*oreos <= 152, "umami_constraint13")



# Add additional constraints
m.addConstr(5*apples - 6*chickens >= 0, "constraint1")
m.addConstr(-5*sandwiches + 1*chickens >= 0, "constraint2")
m.addConstr(10*cereal + 10*chickens - 4*oreos >= 0, "constraint3")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

