
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=0, name="bowls of cereal")
    x1 = model.addVar(lb=0, name="peanutbutter sandwiches")
    x2 = model.addVar(lb=0, name="apples")
    x3 = model.addVar(lb=0, name="rotisserie chickens")
    x4 = model.addVar(lb=0, name="oreos")

    # Define the objective function
    model.setObjective(5*x0 + x1 + 6*x2 + 9*x3 + 7*x4, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(1.75*x1 + 1.88*x4 >= 14, name="sourness_index_constraint_1")
    model.addConstr(0.12*x0 + 1.88*x4 >= 21, name="sourness_index_constraint_2")
    model.addConstr(0.12*x0 + 0.18*x3 >= 23, name="sourness_index_constraint_3")
    model.addConstr(0.12*x0 + 1.75*x1 >= 32, name="sourness_index_constraint_4")
    model.addConstr(1.66*x2 + 0.18*x3 + 1.88*x4 >= 33, name="sourness_index_constraint_5")
    model.addConstr(0.12*x0 + 1.75*x1 + 1.66*x2 + 0.18*x3 + 1.88*x4 >= 33, name="sourness_index_constraint_6")
    model.addConstr(0.13*x0 + 0.97*x4 >= 42, name="umami_index_constraint_1")
    model.addConstr(0.04*x3 + 0.97*x4 >= 35, name="umami_index_constraint_2")
    model.addConstr(1.43*x2 + 0.04*x3 >= 35, name="umami_index_constraint_3")
    model.addConstr(0.75*x1 + 0.97*x4 >= 31, name="umami_index_constraint_4")
    model.addConstr(0.13*x0 + 0.04*x3 + 0.97*x4 >= 44, name="umami_index_constraint_5")
    model.addConstr(0.13*x0 + 0.75*x1 + 1.43*x2 >= 44, name="umami_index_constraint_6")
    model.addConstr(0.13*x0 + 0.04*x3 + 0.97*x4 >= 42, name="umami_index_constraint_7")
    model.addConstr(0.13*x0 + 0.75*x1 + 1.43*x2 >= 42, name="umami_index_constraint_8")
    model.addConstr(0.13*x0 + 0.75*x1 + 1.43*x2 + 0.04*x3 + 0.97*x4 >= 42, name="umami_index_constraint_9")
    model.addConstr(5*x2 - 6*x3 >= 0, name="linear_constraint_1")
    model.addConstr(-5*x1 + x3 >= 0, name="linear_constraint_2")
    model.addConstr(10*x0 + 10*x3 - 4*x4 >= 0, name="linear_constraint_3")
    model.addConstr(0.12*x0 + 1.88*x4 <= 110, name="sourness_index_constraint_10")
    model.addConstr(1.75*x1 + 0.18*x3 + 1.88*x4 <= 89, name="sourness_index_constraint_11")
    model.addConstr(1.75*x1 + 1.66*x2 + 0.18*x3 <= 166, name="sourness_index_constraint_12")
    model.addConstr(1.75*x1 + 1.66*x2 + 1.88*x4 <= 50, name="sourness_index_constraint_13")
    model.addConstr(0.12*x0 + 1.75*x1 + 0.18*x3 <= 55, name="sourness_index_constraint_14")
    model.addConstr(0.12*x0 + 1.66*x2 + 1.88*x4 <= 74, name="sourness_index_constraint_15")
    model.addConstr(0.13*x0 + 0.75*x1 + 0.97*x4 <= 226, name="umami_index_constraint_10")
    model.addConstr(0.75*x1 + 1.43*x2 + 0.97*x4 <= 196, name="umami_index_constraint_11")
    model.addConstr(0.13*x0 + 0.04*x3 + 0.97*x4 <= 82, name="umami_index_constraint_12")
    model.addConstr(1.43*x2 + 0.04*x3 + 0.97*x4 <= 152, name="umami_index_constraint_13")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bowls of cereal: ", x0.varValue)
        print("peanutbutter sandwiches: ", x1.varValue)
        print("apples: ", x2.varValue)
        print("rotisserie chickens: ", x3.varValue)
        print("oreos: ", x4.varValue)
    else:
        print("The model is infeasible")

optimize()
