
import gurobi

def optimize_vitamins():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="vitamin_A", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="vitamin_K", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="vitamin_C", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(1.0*x0 + 7.79*x1 + 9.88*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x0 == 9, name="muscle_growth_vitamin_A")
    model.addConstr(16*x0 == 16, name="cardiovascular_support_vitamin_A")
    model.addConstr(6*x0 == 6, name="digestive_support_vitamin_A")
    model.addConstr(14*x0 == 14, name="cognitive_performance_vitamin_A")
    model.addConstr(15*x0 == 15, name="immune_support_vitamin_A")

    model.addConstr(1*x1 == 1, name="muscle_growth_vitamin_K")
    model.addConstr(15*x1 == 15, name="cardiovascular_support_vitamin_K")
    model.addConstr(15*x1 == 15, name="digestive_support_vitamin_K")
    model.addConstr(5*x1 == 5, name="cognitive_performance_vitamin_K")
    model.addConstr(15*x1 == 15, name="immune_support_vitamin_K")

    model.addConstr(10*x2 == 10, name="muscle_growth_vitamin_C")
    model.addConstr(11*x2 == 11, name="cardiovascular_support_vitamin_C")
    model.addConstr(6*x2 == 6, name="digestive_support_vitamin_C")
    model.addConstr(14*x2 == 14, name="cognitive_performance_vitamin_C")
    model.addConstr(8*x2 == 8, name="immune_support_vitamin_C")

    model.addConstr(9*x0 + x1 >= 44, name="muscle_growth_combined_A_K")
    model.addConstr(9*x0 + 10*x2 >= 68, name="muscle_growth_combined_A_C")
    model.addConstr(9*x0 + x1 + 10*x2 >= 68, name="muscle_growth_combined_A_K_C")

    model.addConstr(16*x0 + 11*x2 >= 53, name="cardiovascular_support_combined_A_C")
    model.addConstr(15*x1 + 11*x2 >= 30, name="cardiovascular_support_combined_K_C")
    model.addConstr(16*x0 + 15*x1 + 11*x2 >= 30, name="cardiovascular_support_combined_A_K_C")

    model.addConstr(6*x0 + 6*x2 >= 39, name="digestive_support_combined_A_C")
    model.addConstr(15*x1 + 6*x2 >= 46, name="digestive_support_combined_K_C")
    model.addConstr(6*x0 + 15*x1 + 6*x2 >= 46, name="digestive_support_combined_A_K_C")

    model.addConstr(5*x1 + 14*x2 >= 25, name="cognitive_performance_combined_K_C")
    model.addConstr(16*x0 + 5*x1 >= 35, name="cognitive_performance_combined_A_K")
    model.addConstr(16*x0 + 14*x2 >= 40, name="cognitive_performance_combined_A_C")
    model.addConstr(16*x0 + 5*x1 + 14*x2 >= 40, name="cognitive_performance_combined_A_K_C")

    model.addConstr(15*x0 + 15*x1 >= 25, name="immune_support_combined_A_K")
    model.addConstr(15*x0 + 8*x2 >= 24, name="immune_support_combined_A_C")
    model.addConstr(15*x0 + 15*x1 + 8*x2 >= 24, name="immune_support_combined_A_K_C")

    model.addConstr(-4*x0 + 2*x1 >= 0, name="interaction_A_K")
    model.addConstr(10*x0 - 8*x2 >= 0, name="interaction_A_C")

    model.addConstr(9*x0 + 10*x2 <= 211, name="muscle_growth_limit_A_C")
    model.addConstr(x1 + 10*x2 <= 140, name="muscle_growth_limit_K_C")
    model.addConstr(9*x0 + x1 <= 213, name="muscle_growth_limit_A_K")

    model.addConstr(16*x0 + 11*x2 <= 172, name="cardiovascular_support_limit_A_C")
    model.addConstr(6*x0 + 6*x2 <= 89, name="digestive_support_limit_A_C")
    model.addConstr(6*x0 + 15*x1 + 6*x2 <= 147, name="digestive_support_limit_A_K_C")

    model.addConstr(5*x1 + 14*x2 <= 170, name="cognitive_performance_limit_K_C")
    model.addConstr(16*x0 + 5*x1 + 14*x2 <= 172, name="cognitive_performance_limit_A_K_C")

    model.addConstr(15*x0 + 15*x1 <= 49, name="immune_support_limit_A_K")

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vitamin A: {x0.varValue}")
        print(f"Vitamin K: {x1.varValue}")
        print(f"Vitamin C: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
