
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
george_hours = model.addVar(lb=0, name="george_hours")
paul_hours = model.addVar(lb=0, name="paul_hours")
laura_hours = model.addVar(lb=0, name="laura_hours")

# Set objective function
model.setObjective(george_hours * paul_hours + 9 * george_hours * laura_hours + paul_hours * laura_hours + 2 * laura_hours * laura_hours + 9 * george_hours + 8 * paul_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(23 * paul_hours * paul_hours + 25 * laura_hours * laura_hours <= 266, "c1")
model.addConstr(29 * george_hours + 23 * paul_hours <= 208, "c2")
model.addConstr(29 * george_hours + 25 * laura_hours <= 106, "c3")
model.addConstr(29 * george_hours * george_hours + 23 * paul_hours * paul_hours + 25 * laura_hours * laura_hours <= 268, "c4")
model.addConstr(29 * george_hours + 23 * paul_hours + 25 * laura_hours <= 268, "c5")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('George Hours: %g' % george_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
    print('Laura Hours: %g' % laura_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

