
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Variables representing hours worked by each person
george_hours = m.addVar(lb=0, name="George_Hours")
paul_hours = m.addVar(lb=0, name="Paul_Hours")
laura_hours = m.addVar(lb=0, name="Laura_Hours")

# Objective function: Maximize the given expression
m.setObjective(
    george_hours * paul_hours + 
    9 * george_hours * laura_hours + 
    paul_hours * laura_hours + 
    2 * (laura_hours ** 2) + 
    9 * george_hours + 
    8 * paul_hours, 
    GRB.MAXIMIZE
)

# Constraints
m.addConstr(29 * george_hours <= 284, name="George_Competence")
m.addConstr(23 * paul_hours <= 266 / (paul_hours ** 2 + laura_hours ** 2) * paul_hours ** 2, name="Paul_Competence") # Adjusted to reflect the problem statement correctly
m.addConstr(25 * laura_hours <= 284, name="Laura_Competence")
m.addConstr((23 * (paul_hours ** 2)) + (25 * (laura_hours ** 2)) <= 266, name="Paul_Laura_Squared_Rating")
m.addConstr((29 * george_hours) + (23 * paul_hours) <= 208, name="George_Paul_Combined_Rating")
m.addConstr((29 * george_hours) + (25 * laura_hours) <= 106, name="George_Laura_Combined_Rating")
m.addConstr((29 * (george_hours ** 2)) + (23 * (paul_hours ** 2)) + (25 * (laura_hours ** 2)) <= 268, name="All_Squared_Ratings")
m.addConstr((29 * george_hours) + (23 * paul_hours) + (25 * laura_hours) <= 268, name="Total_Combined_Rating")

# Optimize the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"George Hours: {george_hours.x}")
    print(f"Paul Hours: {paul_hours.x}")
    print(f"Laura Hours: {laura_hours.x}")
else:
    print("No optimal solution found")
