
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
hours_george = m.addVar(name="hours_worked_by_George", lb=0)
hours_paul = m.addVar(name="hours_worked_by_Paul", lb=0)
hours_laura = m.addVar(name="hours_worked_by_Laura", lb=0)

# Objective function
m.setObjective(1 * hours_george * hours_paul + 9 * hours_george * hours_laura + 
               1 * hours_paul * hours_laura + 2 * hours_laura**2 + 
               9 * hours_george + 8 * hours_paul, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(hours_paul**2 + hours_laura**2 <= 266)
m.addConstr(29 * hours_george + 23 * hours_paul <= 208)
m.addConstr(29 * hours_george + 25 * hours_laura <= 106)
m.addConstr(hours_george**2 + hours_paul**2 + hours_laura**2 <= 268)
m.addConstr(29 * hours_george + 23 * hours_paul + 25 * hours_laura <= 268)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", hours_george.varValue)
    print("Hours worked by Paul: ", hours_paul.varValue)
    print("Hours worked by Laura: ", hours_laura.varValue)
else:
    print("The model is infeasible")
