
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
corn_cobs = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")
black_beans = m.addVar(vtype=GRB.CONTINUOUS, name="black_beans")

# Set objective function
m.setObjective(9*corn_cobs**2 + 9*corn_cobs*black_beans + 4*black_beans**2 + 9*corn_cobs + 8*black_beans, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*corn_cobs + 6*black_beans >= 6, "cost_lower_bound")  # corn cobs squared plus black beans squared must cost at least 6 dollars (approximated)
m.addConstr(1*corn_cobs + 4*black_beans >= 12, "umami_lower_bound")
m.addConstr(5*corn_cobs + 7*black_beans >= 20, "fat_lower_bound")
m.addConstr(7*corn_cobs + 2*black_beans >= 39, "fiber_lower_bound")
m.addConstr(4*corn_cobs**2 + 4*black_beans**2 >= 17, "sourness_lower_bound") # corn cobs squared plus black beans squared must have a sourness index of at least 17 (approximated)
m.addConstr(-4*corn_cobs + 1*black_beans >= 0, "constraint_6")

m.addConstr(7*corn_cobs + 6*black_beans <= 22, "cost_upper_bound") # Combined cost limited to $22
m.addConstr(1*corn_cobs + 4*black_beans <= 16, "umami_upper_bound")
m.addConstr(5*corn_cobs + 7*black_beans <= 54, "fat_upper_bound")
m.addConstr(7*corn_cobs + 2*black_beans <= 71, "fiber_upper_bound")
m.addConstr(4*corn_cobs**2 + 4*black_beans**2 <= 27, "sourness_upper_bound") # corn cobs squared plus black beans squared must have a sourness index of at most 27 (approximated)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('corn_cobs:', corn_cobs.x)
    print('black_beans:', black_beans.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

