
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")  # Amount of corn cobs
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="black_beans")  # Amount of black beans

# Objective function: Maximize
m.setObjective(9*x0**2 + 9*x0*x1 + 4*x1**2 + 9*x0 + 8*x1, GRB.MAXIMIZE)

# Constraints
# Cost constraint
m.addConstr(7*x0 + 6*x1 <= 41, "cost_constraint")

# Umami index constraints
m.addConstr(x0 + 4*x1 >= 12, "umami_index_min")
m.addConstr(x0 + 4*x1 <= 16, "umami_index_max")

# Fat content constraints
m.addConstr(5*x0 + 7*x1 >= 20, "fat_content_min")
m.addConstr(5*x0 + 7*x1 <= 54, "fat_content_max")

# Fiber content constraints
m.addConstr(7*x0 + 2*x1 >= 39, "fiber_content_min")
m.addConstr(7*x0 + 2*x1 <= 71, "fiber_content_max")

# Sourness index constraints (quadratic)
m.addQConstr(x0**2 + x1**2 >= 17/4, "sourness_index_min")  # Adjusted for the coefficients
m.addQConstr(x0**2 + x1**2 <= 27/4, "sourness_index_max")  # Adjusted for the coefficients

# Linear inequality constraint
m.addConstr(-4*x0 + x1 >= 0, "linear_inequality")

# Budget constraints (using original upper bound)
m.addConstr(7*x0 + 6*x1 <= 41, "budget_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Corn cobs: {x0.x}, Black beans: {x1.x}")
else:
    print("No optimal solution found.")
