
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="corn_cobs", vtype=gp.GRB.INTEGER)  # integer variable
x1 = m.addVar(name="black_beans")  # continuous variable

# Objective function
m.setObjective(9*x0**2 + 9*x0*x1 + 4*x1**2 + 9*x0 + 8*x1, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x0 + 6*x1 <= 41, name="total_cost")
m.addConstr(x0**2 + x1**2 >= 6, name="cost_squared")
m.addConstr(x0 + 4*x1 >= 12, name="umami_index")
m.addConstr(5*x0 + 7*x1 >= 20, name="fat")
m.addConstr(7*x0 + 2*x1 >= 39, name="fiber")
m.addConstr((4*x0)**2 + (4*x1)**2 >= 17, name="sourness_index_squared")
m.addConstr(-4*x0 + x1 >= 0, name="linear_constraint")
m.addConstr(7*x0 + 6*x1 <= 22, name="total_cost_alternate")  # Consider if redundant
m.addConstr(x0 + 4*x1 <= 16, name="umami_index_upper")
m.addConstr(5*x0 + 7*x1 <= 54, name="fat_upper")
m.addConstr(7*x0 + 2*x1 <= 71, name="fiber_upper")
m.addConstr((4*x0)**2 + (4*x1)**2 <= 27, name="sourness_index_squared_upper")
m.addConstr(4*x0 + 4*x1 <= 27, name="sourness_index_upper")  # Consider if redundant

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Corn Cobs: {x0.varValue}")
    print(f"Black Beans: {x1.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
