
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Decision variables: hours worked by Paul and Hank
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Objective function: Maximize 8*x0 + 8*x1
m.setObjective(8*x0 + 8*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(14.64*x0 + 0.84*x1 >= 58, "organization_score_min")
m.addConstr(7.43*x0 + 6.44*x1 >= 85, "dollar_cost_per_hour_min")
m.addConstr(22.05*x0 + 15.58*x1 >= 107, "likelihood_to_quit_index_min")
m.addConstr(2.11*x0 + 20.34*x1 >= 93, "paperwork_competence_rating_min")
m.addConstr(7.51*x0 + 9.68*x1 >= 94, "work_quality_rating_min")
m.addConstr(x0 - 8*x1 >= 0, "additional_linear_constraint")

# Upper bounds for combined scores
m.addConstr(14.64*x0 + 0.84*x1 <= 157, "organization_score_max")
m.addConstr(7.43*x0 + 6.44*x1 <= 144, "dollar_cost_per_hour_max")
m.addConstr(22.05*x0 + 15.58*x1 <= 242, "likelihood_to_quit_index_max")
m.addConstr(2.11*x0 + 20.34*x1 <= 344, "paperwork_competence_rating_max")
m.addConstr(7.51*x0 + 9.68*x1 <= 309, "work_quality_rating_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {x0.x}")
    print(f"Hours worked by Hank: {x1.x}")
else:
    print("No optimal solution found.")

