
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x = m.addVar(name="hours_worked_by_Paul", lb=0)  # hours worked by Paul
y = m.addVar(name="hours_worked_by_Hank", lb=0)  # hours worked by Hank

# Define the objective function
m.setObjective(8*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.64*x + 0.84*y >= 58, name="organization_score_constraint")
m.addConstr(7.43*x + 6.44*y >= 85, name="dollar_cost_per_hour_constraint")
m.addConstr(22.05*x + 15.58*y >= 107, name="likelihood_to_quit_index_constraint")
m.addConstr(2.11*x + 20.34*y >= 93, name="paperwork_competence_rating_constraint")
m.addConstr(7.51*x + 9.68*y >= 94, name="work_quality_rating_constraint")
m.addConstr(x - 8*y >= 0, name="hours_worked_constraint")
m.addConstr(14.64*x + 0.84*y <= 157, name="organization_score_upper_bound")
m.addConstr(7.43*x + 6.44*y <= 144, name="dollar_cost_per_hour_upper_bound")
m.addConstr(22.05*x + 15.58*y <= 242, name="likelihood_to_quit_index_upper_bound")
m.addConstr(2.11*x + 20.34*y <= 344, name="paperwork_competence_rating_upper_bound")
m.addConstr(7.51*x + 9.68*y <= 309, name="work_quality_rating_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Paul: {x.varValue}")
    print(f"Hours worked by Hank: {y.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
