
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")

# Set objective function
obj = 2*potassium**2 + 6*potassium*carbohydrates + 6*potassium*calcium + potassium*vitamin_d + 7*carbohydrates*calcium + 6*carbohydrates*vitamin_d + 4*calcium**2 + 4*calcium*vitamin_d + 9*vitamin_d**2 + 9*potassium + carbohydrates + 8*calcium + 6*vitamin_d
m.setObjective(obj, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15*carbohydrates + 16*calcium >= 56, "c1")
m.addConstr(16*potassium + 13*vitamin_d >= 48, "c2")
m.addConstr(16*potassium + 15*carbohydrates >= 53, "c3")
m.addConstr(15*carbohydrates + 13*vitamin_d >= 59, "c4")
m.addConstr(16*calcium + 13*vitamin_d >= 25, "c5")
m.addConstr(16*potassium + 15*carbohydrates + 16*calcium + 13*vitamin_d >= 25, "c6")
m.addConstr(11*carbohydrates**2 + 9*vitamin_d**2 >= 34, "c7")
m.addConstr(3*potassium + 11*carbohydrates >= 38, "c8")
m.addConstr(3*potassium + 11*carbohydrates + 2*calcium + 9*vitamin_d >= 38, "c9")
m.addConstr(15*carbohydrates + 16*calcium <= 142, "c10")
m.addConstr(16*calcium + 13*vitamin_d <= 248, "c11")
m.addConstr(15*carbohydrates**2 + 13*vitamin_d**2 <= 67, "c12")
m.addConstr(16*potassium + 15*carbohydrates <= 229, "c13")
m.addConstr(16*potassium + 13*vitamin_d <= 205, "c14")
m.addConstr(3*potassium**2 + 11*carbohydrates**2 + 9*vitamin_d**2 <= 132, "c15")
m.addConstr(11*carbohydrates**2 + 2*calcium**2 + 9*vitamin_d**2 <= 188, "c16")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

