
import gurobi as gp

# Define the variables
x0 = gp.Var(name="milligrams of potassium", lb=-gp.GRB.INFINITY)
x1 = gp.Var(name="grams of carbohydrates", lb=-gp.GRB.INFINITY)
x2 = gp.Var(name="milligrams of calcium", lb=-gp.GRB.INFINITY)
x3 = gp.Var(name="milligrams of vitamin D", lb=-gp.GRB.INFINITY)

# Create the model
m = gp.Model()

# Objective function
m.setObjective(2*x0**2 + 6*x0*x1 + 6*x0*x2 + x0*x3 + 7*x1*x2 + 6*x1*x3 + 4*x2**2 + 4*x2*x3 + 9*x3**2 + 9*x0 + x1 + 8*x2 + 6*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(16*x0 + 3*x1 + 2*x2 + 9*x3 <= 278) #r1
m.addConstr(16*x0 <= 248) #r0 for x0
m.addConstr(15*x1 <= 248) #r0 for x1
m.addConstr(16*x2 <= 248) #r0 for x2
m.addConstr(13*x3 <= 248) #r0 for x3
m.addConstr(15*x1 + 16*x2 >= 56) 
m.addConstr(16*x0 + 13*x3 >= 48) 
m.addConstr(16*x0 + 15*x1 >= 53) 
m.addConstr(15*x1 + 13*x3 >= 59) 
m.addConstr(16*x2 + 13*x3 >= 25) 
m.addConstr(16*x0 + 15*x1 + 16*x2 + 13*x3 >= 25) 
m.addConstr(x1**2 + x3**2 >= 34) 
m.addConstr(3*x0 + 11*x1 >= 38) 
m.addConstr(3*x0 + 11*x1 + 2*x2 + 9*x3 >= 38) 
m.addConstr(15*x1 + 16*x2 <= 142) 
m.addConstr(16*x2 + 13*x3 <= 248) 
m.addConstr(15**2*x1**2 + 13**2*x3**2 <= 67) 
m.addConstr(16*x0 + 15*x1 <= 229) 
m.addConstr(16*x0 + 13*x3 <= 205) 
m.addConstr(3**2*x0**2 + 11**2*x1**2 + 9**2*x3**2 <= 132) 
m.addConstr(11**2*x1**2 + 2**2*x2**2 + 9**2*x3**2 <= 188)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of potassium: {x0.varValue}")
    print(f"Grams of carbohydrates: {x1.varValue}")
    print(f"Milligrams of calcium: {x2.varValue}")
    print(f"Milligrams of vitamin D: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
