
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
iron = model.addVar(vtype=GRB.CONTINUOUS, name="iron")
potassium = model.addVar(vtype=GRB.INTEGER, name="potassium")

# Set objective function
model.setObjective(5*iron**2 + 4*iron*potassium + 3*potassium**2 + 8*iron + 7*potassium, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*iron + 9*potassium >= 48, "immune_support_index_1")  # Corrected constraint
model.addConstr(2*iron + 9*potassium <= 56, "immune_support_index_2")
model.addConstr(10*iron + 3*potassium >= 18, "muscle_growth_index_1")
model.addConstr(10*iron + 3*potassium <= 55, "muscle_growth_index_2")
model.addConstr(-6*iron + 5*potassium >= 0, "constraint_5")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Iron:', iron.x)
    print('Potassium:', potassium.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', model.status)

