
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_iron")
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_potassium")

# Objective function
m.setObjective(5*x0**2 + 4*x0*x1 + 3*x1**2 + 8*x0 + 7*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(2**2 * x0**2 + 9**2 * x1**2 >= 48, name="immune_support_index_squared")
m.addConstr(2*x0 + 9*x1 >= 48, name="total_immune_support_index")
m.addConstr(10*x0 + 3*x1 >= 18, name="muscle_growth_index")
m.addConstr(-6*x0 + 5*x1 >= 0, name="linear_constraint")
m.addConstr(2*x0 + 9*x1 <= 56, name="upper_bound_immune_support")
m.addConstr(10*x0 + 3*x1 <= 55, name="upper_bound_muscle_growth")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x0.x}")
    print(f"Milligrams of potassium: {x1.x}")
else:
    print("No optimal solution found.")
