
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    iron = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="iron", vtype=gurobi.GRB.CONTINUOUS)
    potassium = model.addVar(lb=0, name="potassium", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5 * iron**2 + 4 * iron * potassium + 3 * potassium**2 + 8 * iron + 7 * potassium, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * iron <= 109, name="immune_support_index_iron")
    model.addConstr(10 * iron <= 65, name="muscle_growth_index_iron")
    model.addConstr(9 * potassium <= 109, name="immune_support_index_potassium")
    model.addConstr(3 * potassium <= 65, name="muscle_growth_index_potassium")

    model.addConstr(iron**2 + potassium**2 >= 48, name="immune_support_index_combined_squared")
    model.addConstr(2 * iron + 9 * potassium >= 48, name="immune_support_index_combined")
    model.addConstr(10 * iron + 3 * potassium >= 18, name="muscle_growth_index_combined")
    model.addConstr(-6 * iron + 5 * potassium >= 0, name="linear_constraint")
    model.addConstr(2 * iron + 9 * potassium <= 56, name="immune_support_index_combined_upper")
    model.addConstr(10 * iron + 3 * potassium <= 55, name="muscle_growth_index_combined_upper")

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Iron: {iron.varValue}")
        print(f"Potassium: {potassium.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The problem has no optimal solution.")

optimize_problem()
