
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("food_optimization")

# Create variables
green_beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="green_beans")
eggs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")
granola_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
steaks = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")

# Set objective function
m.setObjective(1.95 * green_beans + 9.65 * eggs + 1.72 * granola_bars + 4.64 * steaks, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * green_beans + 4 * eggs + 6 * granola_bars + 3 * steaks <= 63, "r0_sourness_index")
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars + 5 * steaks <= 97, "r1_iron")
m.addConstr(4 * green_beans + 2 * eggs + 4 * granola_bars + 3 * steaks <= 78, "r2_umami_index")
m.addConstr(4 * green_beans + 5 * eggs + 6 * granola_bars + 6 * steaks <= 85, "r3_protein")
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars + 8 * steaks <= 59, "r4_carbohydrates")

m.addConstr(4 * eggs + 6 * granola_bars >= 10, "sourness_eggs_granola_bars")
m.addConstr(4 * green_beans + 4 * eggs >= 5, "sourness_green_beans_eggs")
m.addConstr(4 * eggs + 3 * steaks >= 15, "sourness_eggs_steaks")
m.addConstr(4 * green_beans + 4 * eggs + 6 * granola_bars + 3 * steaks >= 15, "sourness_all")

m.addConstr(7 * green_beans + 2 * granola_bars >= 23, "iron_green_beans_granola_bars")
m.addConstr(7 * green_beans + 7 * eggs + 5 * steaks >= 23, "iron_green_beans_eggs_steaks")
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars >= 23, "iron_green_beans_eggs_granola_bars")
m.addConstr(7 * green_beans + 7 * eggs + 5 * steaks >= 14, "iron_green_beans_eggs_steaks_min")
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars >= 14, "iron_green_beans_eggs_granola_bars_min")
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars + 5 * steaks >= 14, "iron_all_min")


m.addConstr(4 * granola_bars + 3 * steaks >= 16, "umami_granola_bars_steaks")
m.addConstr(2 * eggs + 4 * granola_bars >= 6, "umami_eggs_granola_bars")
m.addConstr(4 * green_beans + 4 * granola_bars >= 13, "umami_green_beans_granola_bars")
m.addConstr(2 * eggs + 3 * steaks >= 9, "umami_eggs_steaks")
m.addConstr(4 * green_beans + 2 * eggs + 4 * granola_bars + 3 * steaks >= 9, "umami_all")

m.addConstr(4 * green_beans + 5 * eggs >= 7, "protein_green_beans_eggs")
m.addConstr(4 * green_beans + 6 * granola_bars >= 7, "protein_green_beans_granola_bars")
m.addConstr(5 * eggs + 6 * steaks >= 7, "protein_eggs_steaks")
m.addConstr(5 * eggs + 6 * granola_bars >= 20, "protein_eggs_granola_bars")
m.addConstr(4 * green_beans + 5 * eggs + 6 * steaks >= 13, "protein_green_beans_eggs_steaks")
m.addConstr(4 * green_beans + 5 * eggs + 6 * granola_bars + 6 * steaks >= 13, "protein_all")

m.addConstr(8 * green_beans + 8 * steaks >= 7, "carbohydrates_green_beans_steaks")
m.addConstr(8 * green_beans + 6 * granola_bars >= 7, "carbohydrates_green_beans_granola_bars")
m.addConstr(6 * granola_bars + 8 * steaks >= 14, "carbohydrates_granola_bars_steaks")
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars >= 12, "carbohydrates_green_beans_eggs_granola_bars")
m.addConstr(8 * green_beans + 5 * eggs + 8 * steaks >= 12, "carbohydrates_green_beans_eggs_steaks")
m.addConstr(5 * eggs + 6 * granola_bars + 8 * steaks >= 12, "carbohydrates_eggs_granola_bars_steaks")
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars >= 10, "carbohydrates_green_beans_eggs_granola_bars_min")
m.addConstr(8 * green_beans + 5 * eggs + 8 * steaks >= 10, "carbohydrates_green_beans_eggs_steaks_min")
m.addConstr(5 * eggs + 6 * granola_bars + 8 * steaks >= 10, "carbohydrates_eggs_granola_bars_steaks_min")
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars >= 9, "carbohydrates_green_beans_eggs_granola_bars_min2")
m.addConstr(8 * green_beans + 5 * eggs + 8 * steaks >= 9, "carbohydrates_green_beans_eggs_steaks_min2")
m.addConstr(5 * eggs + 6 * granola_bars + 8 * steaks >= 9, "carbohydrates_eggs_granola_bars_steaks_min2")
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars + 8 * steaks >= 9, "carbohydrates_all_min")


m.addConstr(-3 * green_beans + 6 * eggs >= 0, "custom_1")
m.addConstr(8 * green_beans - 4 * granola_bars >= 0, "custom_2")

m.addConstr(4 * green_beans + 4 * eggs <= 63, "sourness_green_beans_eggs_max")
m.addConstr(7 * green_beans + 5 * steaks <= 95, "iron_green_beans_steaks_max")
m.addConstr(2 * granola_bars + 5 * steaks <= 32, "iron_granola_bars_steaks_max")
m.addConstr(7 * green_beans + 2 * granola_bars <= 26, "iron_green_beans_granola_bars_max")
m.addConstr(7 * green_beans + 7 * eggs <= 94, "iron_green_beans_eggs_max")
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars <= 74, "iron_green_beans_eggs_granola_bars_max")

m.addConstr(2 * eggs + 3 * steaks <= 26, "umami_eggs_steaks_max")
m.addConstr(4 * green_beans + 3 * steaks <= 67, "umami_green_beans_steaks_max")
m.addConstr(2 * eggs + 4 * granola_bars <= 43, "umami_eggs_granola_bars_max")
m.addConstr(4 * green_beans + 2 * eggs <= 57, "umami_green_beans_eggs_max")
m.addConstr(4 * granola_bars + 3 * steaks <= 20, "umami_granola_bars_steaks_max")
m.addConstr(2 * eggs + 4 * granola_bars + 3 * steaks <= 56, "umami_eggs_granola_bars_steaks_max")


m.addConstr(5 * eggs + 6 * steaks <= 38, "protein_eggs_steaks_max")
m.addConstr(5 * eggs + 6 * granola_bars <= 22, "protein_eggs_granola_bars_max")
m.addConstr(6 * granola_bars + 6 * steaks <= 25, "protein_granola_bars_steaks_max")
m.addConstr(5 * eggs + 6 * granola_bars + 6 * steaks <= 28, "protein_eggs_granola_bars_steaks_max")
m.addConstr(4 * green_beans + 6 * granola_bars + 6 * steaks <= 58, "protein_green_beans_granola_bars_steaks_max")

m.addConstr(8 * green_beans + 6 * granola_bars + 8 * steaks <= 29, "carbohydrates_green_beans_granola_bars_steaks_max")
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars <= 46, "carbohydrates_green_beans_eggs_granola_bars_max")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
