
import gurobi

def optimize():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="grams_of_fiber", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="milligrams_of_potassium", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="milligrams_of_magnesium")
    
    # Objective function
    model.setObjective(5 * x0 + x1 + x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(8.44 * x0 + 6.36 * x2 >= 69)
    model.addConstr(8.9 * x1 + 6.36 * x2 >= 37)
    model.addConstr(8.44 * x0 + 8.9 * x1 + 6.36 * x2 >= 37)
    model.addConstr(2.94 * x1 + 3.65 * x2 >= 56)
    model.addConstr(6.43 * x0 + 2.94 * x1 >= 49)
    model.addConstr(6.43 * x0 + 2.94 * x1 + 3.65 * x2 >= 49)
    model.addConstr(0.91 * x0 + 4.62 * x1 >= 33)
    model.addConstr(0.91 * x0 + 4.62 * x1 + 8.97 * x2 >= 33)
    model.addConstr(0.9 * x0 + 6.06 * x1 >= 50)
    model.addConstr(0.9 * x0 + 8.69 * x2 >= 56)
    model.addConstr(6.06 * x1 + 8.69 * x2 >= 62)
    model.addConstr(0.9 * x0 + 6.06 * x1 + 8.69 * x2 >= 62)
    model.addConstr(4.96 * x0 + 6.79 * x2 >= 17)
    model.addConstr(4.96 * x0 + 7.58 * x1 + 6.79 * x2 >= 17)
    model.addConstr(-2 * x1 + 9 * x2 >= 0)
    model.addConstr(-6 * x0 + 3 * x1 >= 0)
    model.addConstr(2.94 * x1 + 3.65 * x2 <= 229)
    model.addConstr(6.43 * x0 + 2.94 * x1 <= 200)
    model.addConstr(7.58 * x1 + 6.79 * x2 <= 97)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Grams of fiber: ", x0.varValue)
        print("Milligrams of potassium: ", x1.varValue)
        print("Milligrams of magnesium: ", x2.varValue)
    else:
        print("No optimal solution found")

optimize()
