
import gurobipy as gp

# Create a new model
m = gp.Model("umami_optimization")

# Create variables
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
knishes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knishes")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chicken_breasts")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="kale_salads")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cherry_pies")
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")

# Set objective function
m.setObjective(3 * bacon + 7 * knishes + 1 * chicken_breasts + 6 * kale_salads + 1 * chicken_thighs + 7 * cherry_pies + 1 * potatoes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * bacon + 7 * potatoes >= 20, "c0")
m.addConstr(4 * kale_salads + 4 * cherry_pies >= 22, "c1")
m.addConstr(2 * knishes + 4 * cherry_pies >= 14, "c2")
m.addConstr(11 * bacon + 4 * cherry_pies >= 14, "c3")
m.addConstr(2 * knishes + 7 * potatoes >= 10, "c4")
m.addConstr(2 * chicken_breasts + 4 * cherry_pies >= 19, "c5")
m.addConstr(11 * bacon + 4 * kale_salads + 7 * potatoes >= 20, "c6")
m.addConstr(2 * chicken_breasts + 4 * kale_salads + 6 * chicken_thighs >= 20, "c7")
m.addConstr(11 * bacon + 2 * chicken_breasts + 4 * cherry_pies >= 20, "c8")
m.addConstr(11 * bacon + 2 * knishes + 6 * chicken_thighs >= 20, "c9")
m.addConstr(11 * bacon + 2 * knishes + 4 * kale_salads >= 20, "c10")
m.addConstr(4 * kale_salads + 6 * chicken_thighs + 4 * cherry_pies >= 20, "c11")
m.addConstr(11 * bacon + 2 * chicken_breasts + 4 * kale_salads >= 20, "c12")
m.addConstr(11 * bacon + 6 * chicken_thighs + 4 * cherry_pies >= 20, "c13")
m.addConstr(2 * knishes + 2 * chicken_breasts + 7 * potatoes >= 20, "c14")
m.addConstr(2 * knishes + 2 * chicken_breasts + 4 * kale_salads >= 20, "c15")

# ... (The rest of the constraints up to c79) ...

m.addConstr(bacon + knishes + chicken_breasts + kale_salads + chicken_thighs + cherry_pies + potatoes >= 17, "c79")
m.addConstr(6 * cherry_pies - 8 * potatoes >= 0, "c80")
m.addConstr(10 * knishes - 2 * kale_salads >= 0, "c81")

# ... (The rest of the constraints up to c91) ...

m.addConstr(11*bacon + 2*knishes + 7*potatoes <= 30, "c84")

# Umami index upper bound
m.addConstr(11 * bacon + 2 * knishes + 2 * chicken_breasts + 4 * kale_salads + 6 * chicken_thighs + 4 * cherry_pies + 7 * potatoes <= 177, "umami_limit")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
