
from gurobipy import Model, GRB

# Create a new model
m = Model("Organization Score Optimization")

# Create variables
bobby_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby_hours")
hank_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")

# Set objective function
m.setObjective(2 * bobby_hours + 9 * hank_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * bobby_hours + 5 * hank_hours >= 14, "combined_score_min")
m.addConstr(10 * bobby_hours - 9 * hank_hours >= 0, "hours_relation")
m.addConstr(6 * bobby_hours + 5 * hank_hours <= 39, "combined_score_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Hours worked by Bobby: {bobby_hours.x}")
    print(f"Hours worked by Hank: {hank_hours.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {m.status}")

