
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Bobby")
x1 = m.addVar(lb=0, name="hours_worked_by_Hank")

# Set the objective function: Maximize 2*x0 + 9*x1
m.setObjective(2*x0 + 9*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 5*x1 >= 14, name="min_organization_score")
m.addConstr(10*x0 - 9*x1 >= 0, name="additional_constraint")
m.addConstr(6*x0 + 5*x1 <= 39, name="max_organization_score")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x0.x}")
    print(f"Hours worked by Hank: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
