
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # Lower bound is 0, assuming can't work negative hours
    x1 = model.addVar(name="hours_worked_by_Hank", lb=0)   # Lower bound is 0, assuming can't work negative hours

    # Objective function: Maximize 2*x0 + 9*x1
    model.setObjective(2*x0 + 9*x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Organization score constraint: 6*x0 + 5*x1 >= 14
    model.addConstr(6*x0 + 5*x1 >= 14, name="org_score_min")

    # Organization score constraint: 6*x0 + 5*x1 <= 39
    model.addConstr(6*x0 + 5*x1 <= 39, name="org_score_max")

    # Linear constraint: 10*x0 - 9*x1 >= 0
    model.addConstr(10*x0 - 9*x1 >= 0, name="linear_constraint")

    # The upper bound of 63 is not binding given the other constraints, so not explicitly coded.

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Bobby: {x0.varValue}")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
